package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{GUID, DryRun}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelDomainConfigChangeResponse(
    dryRun: Optional[DryRun] = Optional.Absent,
    cancelledChangeIds: Optional[Iterable[GUID]] = Optional.Absent,
    cancelledChangeProperties: Optional[
      Iterable[zio.aws.elasticsearch.model.CancelledChangeProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeResponse = {
    import CancelDomainConfigChangeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeResponse
      .builder()
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .optionallyWith(
        cancelledChangeIds.map(value =>
          value.map { item =>
            GUID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cancelledChangeIds)
      .optionallyWith(
        cancelledChangeProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cancelledChangeProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CancelDomainConfigChangeResponse.ReadOnly =
    zio.aws.elasticsearch.model.CancelDomainConfigChangeResponse
      .wrap(buildAwsValue())
}
object CancelDomainConfigChangeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.CancelDomainConfigChangeResponse =
      zio.aws.elasticsearch.model.CancelDomainConfigChangeResponse(
        dryRun.map(value => value),
        cancelledChangeIds.map(value => value),
        cancelledChangeProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dryRun: Optional[DryRun]
    def cancelledChangeIds: Optional[List[GUID]]
    def cancelledChangeProperties: Optional[
      List[zio.aws.elasticsearch.model.CancelledChangeProperty.ReadOnly]
    ]
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getCancelledChangeIds: ZIO[Any, AwsError, List[GUID]] =
      AwsError.unwrapOptionField("cancelledChangeIds", cancelledChangeIds)
    def getCancelledChangeProperties: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.CancelledChangeProperty.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cancelledChangeProperties",
      cancelledChangeProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeResponse
  ) extends zio.aws.elasticsearch.model.CancelDomainConfigChangeResponse.ReadOnly {
    override val dryRun: Optional[DryRun] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.elasticsearch.model.primitives.DryRun(value))
    override val cancelledChangeIds: Optional[List[GUID]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cancelledChangeIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.primitives.GUID(item)
          }.toList
        )
    override val cancelledChangeProperties: Optional[
      List[zio.aws.elasticsearch.model.CancelledChangeProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cancelledChangeProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.CancelledChangeProperty.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeResponse
  ): zio.aws.elasticsearch.model.CancelDomainConfigChangeResponse.ReadOnly =
    new Wrapper(impl)
}
