package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelElasticsearchServiceSoftwareUpdateRequest(
    domainName: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest = {
    import CancelElasticsearchServiceSoftwareUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest.ReadOnly =
    zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest
      .wrap(buildAwsValue())
}
object CancelElasticsearchServiceSoftwareUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest =
      zio.aws.elasticsearch.model
        .CancelElasticsearchServiceSoftwareUpdateRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest
  ) extends zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest
  ): zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
