package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelledChangeProperty(
    propertyName: Optional[String] = Optional.Absent,
    cancelledValue: Optional[String] = Optional.Absent,
    activeValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CancelledChangeProperty = {
    import CancelledChangeProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CancelledChangeProperty
      .builder()
      .optionallyWith(propertyName.map(value => value: java.lang.String))(
        _.propertyName
      )
      .optionallyWith(cancelledValue.map(value => value: java.lang.String))(
        _.cancelledValue
      )
      .optionallyWith(activeValue.map(value => value: java.lang.String))(
        _.activeValue
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.CancelledChangeProperty.ReadOnly =
    zio.aws.elasticsearch.model.CancelledChangeProperty.wrap(buildAwsValue())
}
object CancelledChangeProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CancelledChangeProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.CancelledChangeProperty =
      zio.aws.elasticsearch.model.CancelledChangeProperty(
        propertyName.map(value => value),
        cancelledValue.map(value => value),
        activeValue.map(value => value)
      )
    def propertyName: Optional[String]
    def cancelledValue: Optional[String]
    def activeValue: Optional[String]
    def getPropertyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("propertyName", propertyName)
    def getCancelledValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cancelledValue", cancelledValue)
    def getActiveValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("activeValue", activeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelledChangeProperty
  ) extends zio.aws.elasticsearch.model.CancelledChangeProperty.ReadOnly {
    override val propertyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyName())
      .map(value => value: String)
    override val cancelledValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cancelledValue())
      .map(value => value: String)
    override val activeValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.activeValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelledChangeProperty
  ): zio.aws.elasticsearch.model.CancelledChangeProperty.ReadOnly = new Wrapper(
    impl
  )
}
