package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait ConfigChangeStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus
}
object ConfigChangeStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus
  ): zio.aws.elasticsearch.model.ConfigChangeStatus = value match {
    case software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.INITIALIZING =>
      val r = Initializing
      r
    case software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.VALIDATING =>
      val r = Validating
      r
    case software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.VALIDATION_FAILED =>
      val r = ValidationFailed
      r
    case software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.APPLYING_CHANGES =>
      val r = ApplyingChanges
      r
    case software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.PENDING_USER_INPUT =>
      val r = PendingUserInput
      r
    case software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.CANCELLED =>
      val r = Cancelled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.ConfigChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.elasticsearch.model.ConfigChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.PENDING
  }
  case object Initializing
      extends zio.aws.elasticsearch.model.ConfigChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.INITIALIZING
  }
  case object Validating
      extends zio.aws.elasticsearch.model.ConfigChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.VALIDATING
  }
  case object ValidationFailed
      extends zio.aws.elasticsearch.model.ConfigChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.VALIDATION_FAILED
  }
  case object ApplyingChanges
      extends zio.aws.elasticsearch.model.ConfigChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.APPLYING_CHANGES
  }
  case object Completed extends zio.aws.elasticsearch.model.ConfigChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.COMPLETED
  }
  case object PendingUserInput
      extends zio.aws.elasticsearch.model.ConfigChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.PENDING_USER_INPUT
  }
  case object Cancelled extends zio.aws.elasticsearch.model.ConfigChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus.CANCELLED
  }
}
