package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOutboundCrossClusterSearchConnectionsResponse(
    crossClusterSearchConnections: Optional[
      Iterable[zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse = {
    import DescribeOutboundCrossClusterSearchConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse
      .builder()
      .optionallyWith(
        crossClusterSearchConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.crossClusterSearchConnections)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeOutboundCrossClusterSearchConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse =
      zio.aws.elasticsearch.model
        .DescribeOutboundCrossClusterSearchConnectionsResponse(
          crossClusterSearchConnections.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def crossClusterSearchConnections: Optional[List[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getCrossClusterSearchConnections: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "crossClusterSearchConnections",
      crossClusterSearchConnections
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse
  ) extends zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse.ReadOnly {
    override val crossClusterSearchConnections: Optional[List[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.crossClusterSearchConnections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse
  ): zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
