package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait DomainProcessingStatusType {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType
}
object DomainProcessingStatusType {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType
  ): zio.aws.elasticsearch.model.DomainProcessingStatusType = value match {
    case software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.MODIFYING =>
      val r = Modifying
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.UPGRADING_ENGINE_VERSION =>
      val r = UpgradingEngineVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.UPDATING_SERVICE_SOFTWARE =>
      val r = UpdatingServiceSoftware
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.ISOLATED =>
      val r = Isolated
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.DomainProcessingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType =
      software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating
      extends zio.aws.elasticsearch.model.DomainProcessingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType =
      software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.CREATING
  }
  case object Active
      extends zio.aws.elasticsearch.model.DomainProcessingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType =
      software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.ACTIVE
  }
  case object Modifying
      extends zio.aws.elasticsearch.model.DomainProcessingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType =
      software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.MODIFYING
  }
  case object UpgradingEngineVersion
      extends zio.aws.elasticsearch.model.DomainProcessingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType =
      software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.UPGRADING_ENGINE_VERSION
  }
  case object UpdatingServiceSoftware
      extends zio.aws.elasticsearch.model.DomainProcessingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType =
      software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.UPDATING_SERVICE_SOFTWARE
  }
  case object Isolated
      extends zio.aws.elasticsearch.model.DomainProcessingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType =
      software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.ISOLATED
  }
  case object Deleting
      extends zio.aws.elasticsearch.model.DomainProcessingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType =
      software.amazon.awssdk.services.elasticsearch.model.DomainProcessingStatusType.DELETING
  }
}
