package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait ESWarmPartitionInstanceType {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType
}
object ESWarmPartitionInstanceType {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType
  ): zio.aws.elasticsearch.model.ESWarmPartitionInstanceType = value match {
    case software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType.ULTRAWARM1_MEDIUM_ELASTICSEARCH =>
      val r = `ultrawarm1.medium.elasticsearch`
      r
    case software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType.ULTRAWARM1_LARGE_ELASTICSEARCH =>
      val r = `ultrawarm1.large.elasticsearch`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.ESWarmPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType =
      software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `ultrawarm1.medium.elasticsearch`
      extends zio.aws.elasticsearch.model.ESWarmPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType =
      software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType.ULTRAWARM1_MEDIUM_ELASTICSEARCH
  }
  case object `ultrawarm1.large.elasticsearch`
      extends zio.aws.elasticsearch.model.ESWarmPartitionInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType =
      software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType.ULTRAWARM1_LARGE_ELASTICSEARCH
  }
}
