package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait InitiatedBy {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.InitiatedBy
}
object InitiatedBy {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.InitiatedBy
  ): zio.aws.elasticsearch.model.InitiatedBy = value match {
    case software.amazon.awssdk.services.elasticsearch.model.InitiatedBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.InitiatedBy.CUSTOMER =>
      val r = CUSTOMER
      r
    case software.amazon.awssdk.services.elasticsearch.model.InitiatedBy.SERVICE =>
      val r = SERVICE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.InitiatedBy {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InitiatedBy =
      software.amazon.awssdk.services.elasticsearch.model.InitiatedBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER extends zio.aws.elasticsearch.model.InitiatedBy {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InitiatedBy =
      software.amazon.awssdk.services.elasticsearch.model.InitiatedBy.CUSTOMER
  }
  case object SERVICE extends zio.aws.elasticsearch.model.InitiatedBy {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InitiatedBy =
      software.amazon.awssdk.services.elasticsearch.model.InitiatedBy.SERVICE
  }
}
