package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyingProperties(
    name: Optional[String] = Optional.Absent,
    activeValue: Optional[String] = Optional.Absent,
    pendingValue: Optional[String] = Optional.Absent,
    valueType: Optional[zio.aws.elasticsearch.model.PropertyValueType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties = {
    import ModifyingProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(activeValue.map(value => value: java.lang.String))(
        _.activeValue
      )
      .optionallyWith(pendingValue.map(value => value: java.lang.String))(
        _.pendingValue
      )
      .optionallyWith(valueType.map(value => value.unwrap))(_.valueType)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ModifyingProperties.ReadOnly =
    zio.aws.elasticsearch.model.ModifyingProperties.wrap(buildAwsValue())
}
object ModifyingProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ModifyingProperties =
      zio.aws.elasticsearch.model.ModifyingProperties(
        name.map(value => value),
        activeValue.map(value => value),
        pendingValue.map(value => value),
        valueType.map(value => value)
      )
    def name: Optional[String]
    def activeValue: Optional[String]
    def pendingValue: Optional[String]
    def valueType: Optional[zio.aws.elasticsearch.model.PropertyValueType]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getActiveValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("activeValue", activeValue)
    def getPendingValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pendingValue", pendingValue)
    def getValueType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.PropertyValueType] =
      AwsError.unwrapOptionField("valueType", valueType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties
  ) extends zio.aws.elasticsearch.model.ModifyingProperties.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val activeValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.activeValue())
      .map(value => value: String)
    override val pendingValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingValue())
      .map(value => value: String)
    override val valueType
        : Optional[zio.aws.elasticsearch.model.PropertyValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueType())
        .map(value => zio.aws.elasticsearch.model.PropertyValueType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties
  ): zio.aws.elasticsearch.model.ModifyingProperties.ReadOnly = new Wrapper(
    impl
  )
}
