package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{S3Key, S3BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PackageSource(
    s3BucketName: Optional[S3BucketName] = Optional.Absent,
    s3Key: Optional[S3Key] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.PackageSource = {
    import PackageSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.PackageSource
      .builder()
      .optionallyWith(
        s3BucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.s3BucketName)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.PackageSource.ReadOnly =
    zio.aws.elasticsearch.model.PackageSource.wrap(buildAwsValue())
}
object PackageSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.PackageSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.PackageSource =
      zio.aws.elasticsearch.model.PackageSource(
        s3BucketName.map(value => value),
        s3Key.map(value => value)
      )
    def s3BucketName: Optional[S3BucketName]
    def s3Key: Optional[S3Key]
    def getS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.PackageSource
  ) extends zio.aws.elasticsearch.model.PackageSource.ReadOnly {
    override val s3BucketName: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => zio.aws.elasticsearch.model.primitives.S3BucketName(value))
    override val s3Key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => zio.aws.elasticsearch.model.primitives.S3Key(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.PackageSource
  ): zio.aws.elasticsearch.model.PackageSource.ReadOnly = new Wrapper(impl)
}
