package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{Integer, GUID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReservedElasticsearchInstanceOffering(
    reservedElasticsearchInstanceOfferingId: Optional[GUID] = Optional.Absent,
    elasticsearchInstanceType: Optional[
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    usagePrice: Optional[Double] = Optional.Absent,
    currencyCode: Optional[String] = Optional.Absent,
    paymentOption: Optional[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ] = Optional.Absent,
    recurringCharges: Optional[
      Iterable[zio.aws.elasticsearch.model.RecurringCharge]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering = {
    import ReservedElasticsearchInstanceOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering
      .builder()
      .optionallyWith(
        reservedElasticsearchInstanceOfferingId.map(value =>
          GUID.unwrap(value): java.lang.String
        )
      )(_.reservedElasticsearchInstanceOfferingId)
      .optionallyWith(elasticsearchInstanceType.map(value => value.unwrap))(
        _.elasticsearchInstanceType
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly =
    zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering
      .wrap(buildAwsValue())
}
object ReservedElasticsearchInstanceOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering =
      zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering(
        reservedElasticsearchInstanceOfferingId.map(value => value),
        elasticsearchInstanceType.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        paymentOption.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedElasticsearchInstanceOfferingId: Optional[GUID]
    def elasticsearchInstanceType
        : Optional[zio.aws.elasticsearch.model.ESPartitionInstanceType]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def usagePrice: Optional[Double]
    def currencyCode: Optional[String]
    def paymentOption: Optional[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ]
    def recurringCharges
        : Optional[List[zio.aws.elasticsearch.model.RecurringCharge.ReadOnly]]
    def getReservedElasticsearchInstanceOfferingId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField(
        "reservedElasticsearchInstanceOfferingId",
        reservedElasticsearchInstanceOfferingId
      )
    def getElasticsearchInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = AwsError.unwrapOptionField(
      "elasticsearchInstanceType",
      elasticsearchInstanceType
    )
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getPaymentOption: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering
  ) extends zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly {
    override val reservedElasticsearchInstanceOfferingId: Optional[GUID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedElasticsearchInstanceOfferingId())
        .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val elasticsearchInstanceType
        : Optional[zio.aws.elasticsearch.model.ESPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticsearchInstanceType())
        .map(value =>
          zio.aws.elasticsearch.model.ESPartitionInstanceType.wrap(value)
        )
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val usagePrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Double)
    override val currencyCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currencyCode())
      .map(value => value: String)
    override val paymentOption: Optional[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.paymentOption())
      .map(value =>
        zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
          .wrap(value)
      )
    override val recurringCharges
        : Optional[List[zio.aws.elasticsearch.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.RecurringCharge.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering
  ): zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly =
    new Wrapper(impl)
}
