package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait ReservedElasticsearchInstancePaymentOption {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
}
object ReservedElasticsearchInstancePaymentOption {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
  ): zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption =
    value match {
      case software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption.ALL_UPFRONT =>
        val r = ALL_UPFRONT
        r
      case software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption.PARTIAL_UPFRONT =>
        val r = PARTIAL_UPFRONT
        r
      case software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption.NO_UPFRONT =>
        val r = NO_UPFRONT
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption =
      software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL_UPFRONT
      extends zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption =
      software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption.ALL_UPFRONT
  }
  case object PARTIAL_UPFRONT
      extends zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption =
      software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption.PARTIAL_UPFRONT
  }
  case object NO_UPFRONT
      extends zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption =
      software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption.NO_UPFRONT
  }
}
