package zio.aws.elasticsearch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.DeploymentCloseDateTimeStamp
import scala.jdk.CollectionConverters.*
final case class ServiceSoftwareOptions(
    currentVersion: Optional[String] = Optional.Absent,
    newVersion: Optional[String] = Optional.Absent,
    updateAvailable: Optional[Boolean] = Optional.Absent,
    cancellable: Optional[Boolean] = Optional.Absent,
    updateStatus: Optional[zio.aws.elasticsearch.model.DeploymentStatus] =
      Optional.Absent,
    description: Optional[String] = Optional.Absent,
    automatedUpdateDate: Optional[DeploymentCloseDateTimeStamp] =
      Optional.Absent,
    optionalDeployment: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions = {
    import ServiceSoftwareOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions
      .builder()
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(newVersion.map(value => value: java.lang.String))(
        _.newVersion
      )
      .optionallyWith(updateAvailable.map(value => value: java.lang.Boolean))(
        _.updateAvailable
      )
      .optionallyWith(cancellable.map(value => value: java.lang.Boolean))(
        _.cancellable
      )
      .optionallyWith(updateStatus.map(value => value.unwrap))(_.updateStatus)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        automatedUpdateDate.map(value =>
          DeploymentCloseDateTimeStamp.unwrap(value): Instant
        )
      )(_.automatedUpdateDate)
      .optionallyWith(
        optionalDeployment.map(value => value: java.lang.Boolean)
      )(_.optionalDeployment)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly =
    zio.aws.elasticsearch.model.ServiceSoftwareOptions.wrap(buildAwsValue())
}
object ServiceSoftwareOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ServiceSoftwareOptions =
      zio.aws.elasticsearch.model.ServiceSoftwareOptions(
        currentVersion.map(value => value),
        newVersion.map(value => value),
        updateAvailable.map(value => value),
        cancellable.map(value => value),
        updateStatus.map(value => value),
        description.map(value => value),
        automatedUpdateDate.map(value => value),
        optionalDeployment.map(value => value)
      )
    def currentVersion: Optional[String]
    def newVersion: Optional[String]
    def updateAvailable: Optional[Boolean]
    def cancellable: Optional[Boolean]
    def updateStatus: Optional[zio.aws.elasticsearch.model.DeploymentStatus]
    def description: Optional[String]
    def automatedUpdateDate: Optional[DeploymentCloseDateTimeStamp]
    def optionalDeployment: Optional[Boolean]
    def getCurrentVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getNewVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newVersion", newVersion)
    def getUpdateAvailable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("updateAvailable", updateAvailable)
    def getCancellable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cancellable", cancellable)
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.DeploymentStatus] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutomatedUpdateDate
        : ZIO[Any, AwsError, DeploymentCloseDateTimeStamp] =
      AwsError.unwrapOptionField("automatedUpdateDate", automatedUpdateDate)
    def getOptionalDeployment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("optionalDeployment", optionalDeployment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions
  ) extends zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly {
    override val currentVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: String)
    override val newVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.newVersion())
      .map(value => value: String)
    override val updateAvailable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.updateAvailable())
      .map(value => value: Boolean)
    override val cancellable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cancellable())
      .map(value => value: Boolean)
    override val updateStatus
        : Optional[zio.aws.elasticsearch.model.DeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateStatus())
        .map(value => zio.aws.elasticsearch.model.DeploymentStatus.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val automatedUpdateDate: Optional[DeploymentCloseDateTimeStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedUpdateDate())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .DeploymentCloseDateTimeStamp(value)
        )
    override val optionalDeployment: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.optionalDeployment())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions
  ): zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly = new Wrapper(
    impl
  )
}
