package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait TimeUnit {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.TimeUnit
}
object TimeUnit {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.TimeUnit
  ): zio.aws.elasticsearch.model.TimeUnit = value match {
    case software.amazon.awssdk.services.elasticsearch.model.TimeUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.TimeUnit.HOURS =>
      val r = HOURS
      r
  }
  case object unknownToSdkVersion extends zio.aws.elasticsearch.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.TimeUnit =
      software.amazon.awssdk.services.elasticsearch.model.TimeUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object HOURS extends zio.aws.elasticsearch.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.TimeUnit =
      software.amazon.awssdk.services.elasticsearch.model.TimeUnit.HOURS
  }
}
