package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait VpcEndpointStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus
}
object VpcEndpointStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus
  ): zio.aws.elasticsearch.model.VpcEndpointStatus = value match {
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.elasticsearch.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.CREATING
  }
  case object CREATE_FAILED
      extends zio.aws.elasticsearch.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.CREATE_FAILED
  }
  case object ACTIVE extends zio.aws.elasticsearch.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.ACTIVE
  }
  case object UPDATING extends zio.aws.elasticsearch.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.UPDATING
  }
  case object UPDATE_FAILED
      extends zio.aws.elasticsearch.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.UPDATE_FAILED
  }
  case object DELETING extends zio.aws.elasticsearch.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.DELETING
  }
  case object DELETE_FAILED
      extends zio.aws.elasticsearch.model.VpcEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus.DELETE_FAILED
  }
}
