package zio.aws.elasticsearch
import zio.aws.elasticsearch.model.primitives.{
  ElasticsearchVersionString,
  DescribePackagesFilterValue,
  Issue,
  InstanceRole,
  DomainName,
  GUID,
  ServiceUrl,
  LimitValue,
  VpcEndpointId,
  NonEmptyString
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.elasticsearch.model.primitives.AutoTuneDate.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ARN extends zio.prelude.Subtype[String]
    type ARN = zio.aws.elasticsearch.model.primitives.ARN.Type
    object AWSAccount extends zio.prelude.Subtype[String]
    type AWSAccount = zio.aws.elasticsearch.model.primitives.AWSAccount.Type
    object AutoTuneDate extends zio.prelude.Subtype[Instant]
    type AutoTuneDate = zio.aws.elasticsearch.model.primitives.AutoTuneDate.Type
    object BackendRole extends zio.prelude.Subtype[String]
    type BackendRole = zio.aws.elasticsearch.model.primitives.BackendRole.Type
    object ChangeProgressStageName extends zio.prelude.Subtype[String]
    type ChangeProgressStageName =
      zio.aws.elasticsearch.model.primitives.ChangeProgressStageName.Type
    object ChangeProgressStageStatus extends zio.prelude.Subtype[String]
    type ChangeProgressStageStatus =
      zio.aws.elasticsearch.model.primitives.ChangeProgressStageStatus.Type
    object ClientToken extends zio.prelude.Subtype[String]
    type ClientToken = zio.aws.elasticsearch.model.primitives.ClientToken.Type
    object CloudWatchLogsLogGroupArn extends zio.prelude.Subtype[String]
    type CloudWatchLogsLogGroupArn =
      zio.aws.elasticsearch.model.primitives.CloudWatchLogsLogGroupArn.Type
    object CommitMessage extends zio.prelude.Subtype[String]
    type CommitMessage =
      zio.aws.elasticsearch.model.primitives.CommitMessage.Type
    object ConnectionAlias extends zio.prelude.Subtype[String]
    type ConnectionAlias =
      zio.aws.elasticsearch.model.primitives.ConnectionAlias.Type
    object CreatedAt extends zio.prelude.Subtype[Instant]
    type CreatedAt = zio.aws.elasticsearch.model.primitives.CreatedAt.Type
    object CrossClusterSearchConnectionId extends zio.prelude.Subtype[String]
    type CrossClusterSearchConnectionId =
      zio.aws.elasticsearch.model.primitives.CrossClusterSearchConnectionId.Type
    object CrossClusterSearchConnectionStatusMessage
        extends zio.prelude.Subtype[String]
    type CrossClusterSearchConnectionStatusMessage =
      zio.aws.elasticsearch.model.primitives.CrossClusterSearchConnectionStatusMessage.Type
    object DeploymentCloseDateTimeStamp extends zio.prelude.Subtype[Instant]
    type DeploymentCloseDateTimeStamp =
      zio.aws.elasticsearch.model.primitives.DeploymentCloseDateTimeStamp.Type
    object DeploymentType extends zio.prelude.Subtype[String]
    type DeploymentType =
      zio.aws.elasticsearch.model.primitives.DeploymentType.Type
    object DescribePackagesFilterValue extends zio.prelude.Subtype[String]
    type DescribePackagesFilterValue =
      zio.aws.elasticsearch.model.primitives.DescribePackagesFilterValue.Type
    object Description extends zio.prelude.Subtype[String]
    type Description = zio.aws.elasticsearch.model.primitives.Description.Type
    object DisableTimestamp extends zio.prelude.Subtype[Instant]
    type DisableTimestamp =
      zio.aws.elasticsearch.model.primitives.DisableTimestamp.Type
    object DomainArn extends zio.prelude.Subtype[String]
    type DomainArn = zio.aws.elasticsearch.model.primitives.DomainArn.Type
    object DomainId extends zio.prelude.Subtype[String]
    type DomainId = zio.aws.elasticsearch.model.primitives.DomainId.Type
    object DomainName extends zio.prelude.Subtype[String]
    type DomainName = zio.aws.elasticsearch.model.primitives.DomainName.Type
    object DomainNameFqdn extends zio.prelude.Subtype[String]
    type DomainNameFqdn =
      zio.aws.elasticsearch.model.primitives.DomainNameFqdn.Type
    object DryRun extends zio.prelude.Subtype[Boolean]
    type DryRun = zio.aws.elasticsearch.model.primitives.DryRun.Type
    object DurationValue extends zio.prelude.Subtype[Long]
    type DurationValue =
      zio.aws.elasticsearch.model.primitives.DurationValue.Type
    object ElasticsearchVersionString extends zio.prelude.Subtype[String]
    type ElasticsearchVersionString =
      zio.aws.elasticsearch.model.primitives.ElasticsearchVersionString.Type
    object Endpoint extends zio.prelude.Subtype[String]
    type Endpoint = zio.aws.elasticsearch.model.primitives.Endpoint.Type
    object ErrorMessage extends zio.prelude.Subtype[String]
    type ErrorMessage = zio.aws.elasticsearch.model.primitives.ErrorMessage.Type
    object ErrorType extends zio.prelude.Subtype[String]
    type ErrorType = zio.aws.elasticsearch.model.primitives.ErrorType.Type
    object GUID extends zio.prelude.Subtype[String]
    type GUID = zio.aws.elasticsearch.model.primitives.GUID.Type
    object IdentityPoolId extends zio.prelude.Subtype[String]
    type IdentityPoolId =
      zio.aws.elasticsearch.model.primitives.IdentityPoolId.Type
    object InstanceCount extends zio.prelude.Subtype[Int]
    type InstanceCount =
      zio.aws.elasticsearch.model.primitives.InstanceCount.Type
    object InstanceRole extends zio.prelude.Subtype[String]
    type InstanceRole = zio.aws.elasticsearch.model.primitives.InstanceRole.Type
    type Integer = Int
    object IntegerClass extends zio.prelude.Subtype[Int]
    type IntegerClass = zio.aws.elasticsearch.model.primitives.IntegerClass.Type
    object Issue extends zio.prelude.Subtype[String]
    type Issue = zio.aws.elasticsearch.model.primitives.Issue.Type
    object KmsKeyId extends zio.prelude.Subtype[String]
    type KmsKeyId = zio.aws.elasticsearch.model.primitives.KmsKeyId.Type
    object LastUpdated extends zio.prelude.Subtype[Instant]
    type LastUpdated = zio.aws.elasticsearch.model.primitives.LastUpdated.Type
    object LimitName extends zio.prelude.Subtype[String]
    type LimitName = zio.aws.elasticsearch.model.primitives.LimitName.Type
    object LimitValue extends zio.prelude.Subtype[String]
    type LimitValue = zio.aws.elasticsearch.model.primitives.LimitValue.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.elasticsearch.model.primitives.MaxResults.Type
    object MaximumInstanceCount extends zio.prelude.Subtype[Int]
    type MaximumInstanceCount =
      zio.aws.elasticsearch.model.primitives.MaximumInstanceCount.Type
    object Message extends zio.prelude.Subtype[String]
    type Message = zio.aws.elasticsearch.model.primitives.Message.Type
    object MinimumInstanceCount extends zio.prelude.Subtype[Int]
    type MinimumInstanceCount =
      zio.aws.elasticsearch.model.primitives.MinimumInstanceCount.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.elasticsearch.model.primitives.NextToken.Type
    object NonEmptyString extends zio.prelude.Subtype[String]
    type NonEmptyString =
      zio.aws.elasticsearch.model.primitives.NonEmptyString.Type
    object OwnerId extends zio.prelude.Subtype[String]
    type OwnerId = zio.aws.elasticsearch.model.primitives.OwnerId.Type
    object PackageDescription extends zio.prelude.Subtype[String]
    type PackageDescription =
      zio.aws.elasticsearch.model.primitives.PackageDescription.Type
    object PackageID extends zio.prelude.Subtype[String]
    type PackageID = zio.aws.elasticsearch.model.primitives.PackageID.Type
    object PackageName extends zio.prelude.Subtype[String]
    type PackageName = zio.aws.elasticsearch.model.primitives.PackageName.Type
    object PackageVersion extends zio.prelude.Subtype[String]
    type PackageVersion =
      zio.aws.elasticsearch.model.primitives.PackageVersion.Type
    object Password extends zio.prelude.Subtype[String]
    type Password = zio.aws.elasticsearch.model.primitives.Password.Type
    object PolicyDocument extends zio.prelude.Subtype[String]
    type PolicyDocument =
      zio.aws.elasticsearch.model.primitives.PolicyDocument.Type
    object ReferencePath extends zio.prelude.Subtype[String]
    type ReferencePath =
      zio.aws.elasticsearch.model.primitives.ReferencePath.Type
    object Region extends zio.prelude.Subtype[String]
    type Region = zio.aws.elasticsearch.model.primitives.Region.Type
    object ReservationToken extends zio.prelude.Subtype[String]
    type ReservationToken =
      zio.aws.elasticsearch.model.primitives.ReservationToken.Type
    object RoleArn extends zio.prelude.Subtype[String]
    type RoleArn = zio.aws.elasticsearch.model.primitives.RoleArn.Type
    object S3BucketName extends zio.prelude.Subtype[String]
    type S3BucketName = zio.aws.elasticsearch.model.primitives.S3BucketName.Type
    object S3Key extends zio.prelude.Subtype[String]
    type S3Key = zio.aws.elasticsearch.model.primitives.S3Key.Type
    object SAMLEntityId extends zio.prelude.Subtype[String]
    type SAMLEntityId = zio.aws.elasticsearch.model.primitives.SAMLEntityId.Type
    object SAMLMetadata extends zio.prelude.Subtype[String]
    type SAMLMetadata = zio.aws.elasticsearch.model.primitives.SAMLMetadata.Type
    object ScheduledAutoTuneDescription extends zio.prelude.Subtype[String]
    type ScheduledAutoTuneDescription =
      zio.aws.elasticsearch.model.primitives.ScheduledAutoTuneDescription.Type
    object ServiceUrl extends zio.prelude.Subtype[String]
    type ServiceUrl = zio.aws.elasticsearch.model.primitives.ServiceUrl.Type
    object StartAt extends zio.prelude.Subtype[Instant]
    type StartAt = zio.aws.elasticsearch.model.primitives.StartAt.Type
    object StartTimestamp extends zio.prelude.Subtype[Instant]
    type StartTimestamp =
      zio.aws.elasticsearch.model.primitives.StartTimestamp.Type
    object StorageSubTypeName extends zio.prelude.Subtype[String]
    type StorageSubTypeName =
      zio.aws.elasticsearch.model.primitives.StorageSubTypeName.Type
    object StorageTypeName extends zio.prelude.Subtype[String]
    type StorageTypeName =
      zio.aws.elasticsearch.model.primitives.StorageTypeName.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.elasticsearch.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.elasticsearch.model.primitives.TagValue.Type
    object TotalNumberOfStages extends zio.prelude.Subtype[Int]
    type TotalNumberOfStages =
      zio.aws.elasticsearch.model.primitives.TotalNumberOfStages.Type
    object UIntValue extends zio.prelude.Subtype[Int]
    type UIntValue = zio.aws.elasticsearch.model.primitives.UIntValue.Type
    object UpdateTimestamp extends zio.prelude.Subtype[Instant]
    type UpdateTimestamp =
      zio.aws.elasticsearch.model.primitives.UpdateTimestamp.Type
    object UpgradeName extends zio.prelude.Subtype[String]
    type UpgradeName = zio.aws.elasticsearch.model.primitives.UpgradeName.Type
    object UserPoolId extends zio.prelude.Subtype[String]
    type UserPoolId = zio.aws.elasticsearch.model.primitives.UserPoolId.Type
    object Username extends zio.prelude.Subtype[String]
    type Username = zio.aws.elasticsearch.model.primitives.Username.Type
    object VpcEndpointId extends zio.prelude.Subtype[String]
    type VpcEndpointId =
      zio.aws.elasticsearch.model.primitives.VpcEndpointId.Type
  }
  type AdditionalLimitList = List[zio.aws.elasticsearch.model.AdditionalLimit]
  type AdvancedOptions = Map[String, String]
  type AuthorizedPrincipalList =
    List[zio.aws.elasticsearch.model.AuthorizedPrincipal]
  type AutoTuneList = List[zio.aws.elasticsearch.model.AutoTune]
  type AutoTuneMaintenanceScheduleList =
    List[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule]
  type CancelledChangePropertyList =
    List[zio.aws.elasticsearch.model.CancelledChangeProperty]
  type ChangeProgressStageList =
    List[zio.aws.elasticsearch.model.ChangeProgressStage]
  type CompatibleElasticsearchVersionsList =
    List[zio.aws.elasticsearch.model.CompatibleVersionsMap]
  type DescribePackagesFilterList =
    List[zio.aws.elasticsearch.model.DescribePackagesFilter]
  type DescribePackagesFilterValues = List[DescribePackagesFilterValue]
  type DomainInfoList = List[zio.aws.elasticsearch.model.DomainInfo]
  type DomainNameList = List[DomainName]
  type DomainPackageDetailsList =
    List[zio.aws.elasticsearch.model.DomainPackageDetails]
  type ElasticsearchDomainStatusList =
    List[zio.aws.elasticsearch.model.ElasticsearchDomainStatus]
  type ElasticsearchInstanceTypeList =
    List[zio.aws.elasticsearch.model.ESPartitionInstanceType]
  type ElasticsearchVersionList = List[ElasticsearchVersionString]
  type EndpointsMap = Map[String, ServiceUrl]
  type FilterList = List[zio.aws.elasticsearch.model.Filter]
  type GUIDList = List[GUID]
  type InboundCrossClusterSearchConnections =
    List[zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection]
  type Issues = List[Issue]
  type LimitValueList = List[LimitValue]
  type LimitsByRole = Map[InstanceRole, zio.aws.elasticsearch.model.Limits]
  type LogPublishingOptions = Map[
    zio.aws.elasticsearch.model.LogType,
    zio.aws.elasticsearch.model.LogPublishingOption
  ]
  type ModifyingPropertiesList =
    List[zio.aws.elasticsearch.model.ModifyingProperties]
  type OutboundCrossClusterSearchConnections =
    List[zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection]
  type PackageDetailsList = List[zio.aws.elasticsearch.model.PackageDetails]
  type PackageVersionHistoryList =
    List[zio.aws.elasticsearch.model.PackageVersionHistory]
  type RecurringChargeList = List[zio.aws.elasticsearch.model.RecurringCharge]
  type ReservedElasticsearchInstanceList =
    List[zio.aws.elasticsearch.model.ReservedElasticsearchInstance]
  type ReservedElasticsearchInstanceOfferingList =
    List[zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering]
  type StorageTypeLimitList = List[zio.aws.elasticsearch.model.StorageTypeLimit]
  type StorageTypeList = List[zio.aws.elasticsearch.model.StorageType]
  type StringList = List[String]
  type TagList = List[zio.aws.elasticsearch.model.Tag]
  type UpgradeHistoryList = List[zio.aws.elasticsearch.model.UpgradeHistory]
  type UpgradeStepsList = List[zio.aws.elasticsearch.model.UpgradeStepItem]
  type ValueStringList = List[NonEmptyString]
  type VpcEndpointErrorList = List[zio.aws.elasticsearch.model.VpcEndpointError]
  type VpcEndpointIdList = List[VpcEndpointId]
  type VpcEndpointSummaryList =
    List[zio.aws.elasticsearch.model.VpcEndpointSummary]
  type VpcEndpoints = List[zio.aws.elasticsearch.model.VpcEndpoint]
}
