package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AcceptInboundCrossClusterSearchConnectionResponse(
    crossClusterSearchConnection: Optional[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse = {
    import AcceptInboundCrossClusterSearchConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse
      .builder()
      .optionallyWith(
        crossClusterSearchConnection.map(value => value.buildAwsValue())
      )(_.crossClusterSearchConnection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse.ReadOnly =
    zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse
      .wrap(buildAwsValue())
}
object AcceptInboundCrossClusterSearchConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse =
      zio.aws.elasticsearch.model
        .AcceptInboundCrossClusterSearchConnectionResponse(
          crossClusterSearchConnection.map(value => value.asEditable)
        )
    def crossClusterSearchConnection: Optional[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ]
    def getCrossClusterSearchConnection: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ] = AwsError.unwrapOptionField(
      "crossClusterSearchConnection",
      crossClusterSearchConnection
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse
  ) extends zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse.ReadOnly {
    override val crossClusterSearchConnection: Optional[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.crossClusterSearchConnection())
      .map(value =>
        zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse
  ): zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
