package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AuthorizedPrincipal(
    principalType: Optional[zio.aws.elasticsearch.model.PrincipalType] =
      Optional.Absent,
    principal: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AuthorizedPrincipal = {
    import AuthorizedPrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AuthorizedPrincipal
      .builder()
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .optionallyWith(principal.map(value => value: java.lang.String))(
        _.principal
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AuthorizedPrincipal.ReadOnly =
    zio.aws.elasticsearch.model.AuthorizedPrincipal.wrap(buildAwsValue())
}
object AuthorizedPrincipal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AuthorizedPrincipal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AuthorizedPrincipal =
      zio.aws.elasticsearch.model.AuthorizedPrincipal(
        principalType.map(value => value),
        principal.map(value => value)
      )
    def principalType: Optional[zio.aws.elasticsearch.model.PrincipalType]
    def principal: Optional[String]
    def getPrincipalType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
    def getPrincipal: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principal", principal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AuthorizedPrincipal
  ) extends zio.aws.elasticsearch.model.AuthorizedPrincipal.ReadOnly {
    override val principalType
        : Optional[zio.aws.elasticsearch.model.PrincipalType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalType())
        .map(value => zio.aws.elasticsearch.model.PrincipalType.wrap(value))
    override val principal: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principal())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AuthorizedPrincipal
  ): zio.aws.elasticsearch.model.AuthorizedPrincipal.ReadOnly = new Wrapper(
    impl
  )
}
