package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{DryRun, DomainName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelDomainConfigChangeRequest(
    domainName: DomainName,
    dryRun: Optional[DryRun] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeRequest = {
    import CancelDomainConfigChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CancelDomainConfigChangeRequest.ReadOnly =
    zio.aws.elasticsearch.model.CancelDomainConfigChangeRequest
      .wrap(buildAwsValue())
}
object CancelDomainConfigChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.CancelDomainConfigChangeRequest =
      zio.aws.elasticsearch.model
        .CancelDomainConfigChangeRequest(domainName, dryRun.map(value => value))
    def domainName: DomainName
    def dryRun: Optional[DryRun]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeRequest
  ) extends zio.aws.elasticsearch.model.CancelDomainConfigChangeRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val dryRun: Optional[DryRun] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.elasticsearch.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelDomainConfigChangeRequest
  ): zio.aws.elasticsearch.model.CancelDomainConfigChangeRequest.ReadOnly =
    new Wrapper(impl)
}
