package zio.aws.elasticsearch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{UpdateTimestamp, Message, GUID}
import scala.jdk.CollectionConverters.*
final case class ChangeProgressDetails(
    changeId: Optional[GUID] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    configChangeStatus: Optional[
      zio.aws.elasticsearch.model.ConfigChangeStatus
    ] = Optional.Absent,
    startTime: Optional[UpdateTimestamp] = Optional.Absent,
    lastUpdatedTime: Optional[UpdateTimestamp] = Optional.Absent,
    initiatedBy: Optional[zio.aws.elasticsearch.model.InitiatedBy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails = {
    import ChangeProgressDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails
      .builder()
      .optionallyWith(
        changeId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.changeId)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(configChangeStatus.map(value => value.unwrap))(
        _.configChangeStatus
      )
      .optionallyWith(
        startTime.map(value => UpdateTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        lastUpdatedTime.map(value => UpdateTimestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(initiatedBy.map(value => value.unwrap))(_.initiatedBy)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly =
    zio.aws.elasticsearch.model.ChangeProgressDetails.wrap(buildAwsValue())
}
object ChangeProgressDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ChangeProgressDetails =
      zio.aws.elasticsearch.model.ChangeProgressDetails(
        changeId.map(value => value),
        message.map(value => value),
        configChangeStatus.map(value => value),
        startTime.map(value => value),
        lastUpdatedTime.map(value => value),
        initiatedBy.map(value => value)
      )
    def changeId: Optional[GUID]
    def message: Optional[Message]
    def configChangeStatus
        : Optional[zio.aws.elasticsearch.model.ConfigChangeStatus]
    def startTime: Optional[UpdateTimestamp]
    def lastUpdatedTime: Optional[UpdateTimestamp]
    def initiatedBy: Optional[zio.aws.elasticsearch.model.InitiatedBy]
    def getChangeId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("changeId", changeId)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getConfigChangeStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.ConfigChangeStatus] =
      AwsError.unwrapOptionField("configChangeStatus", configChangeStatus)
    def getStartTime: ZIO[Any, AwsError, UpdateTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, UpdateTimestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getInitiatedBy
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.InitiatedBy] =
      AwsError.unwrapOptionField("initiatedBy", initiatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails
  ) extends zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly {
    override val changeId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.changeId())
      .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.elasticsearch.model.primitives.Message(value))
    override val configChangeStatus
        : Optional[zio.aws.elasticsearch.model.ConfigChangeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configChangeStatus())
        .map(value =>
          zio.aws.elasticsearch.model.ConfigChangeStatus.wrap(value)
        )
    override val startTime: Optional[UpdateTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.UpdateTimestamp(value)
      )
    override val lastUpdatedTime: Optional[UpdateTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.UpdateTimestamp(value)
        )
    override val initiatedBy
        : Optional[zio.aws.elasticsearch.model.InitiatedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiatedBy())
        .map(value => zio.aws.elasticsearch.model.InitiatedBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails
  ): zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly = new Wrapper(
    impl
  )
}
