package zio.aws.elasticsearch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{
  TotalNumberOfStages,
  UpdateTimestamp,
  GUID
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ChangeProgressStatusDetails(
    changeId: Optional[GUID] = Optional.Absent,
    startTime: Optional[UpdateTimestamp] = Optional.Absent,
    status: Optional[zio.aws.elasticsearch.model.OverallChangeStatus] =
      Optional.Absent,
    pendingProperties: Optional[Iterable[String]] = Optional.Absent,
    completedProperties: Optional[Iterable[String]] = Optional.Absent,
    totalNumberOfStages: Optional[TotalNumberOfStages] = Optional.Absent,
    changeProgressStages: Optional[
      Iterable[zio.aws.elasticsearch.model.ChangeProgressStage]
    ] = Optional.Absent,
    configChangeStatus: Optional[
      zio.aws.elasticsearch.model.ConfigChangeStatus
    ] = Optional.Absent,
    lastUpdatedTime: Optional[UpdateTimestamp] = Optional.Absent,
    initiatedBy: Optional[zio.aws.elasticsearch.model.InitiatedBy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails = {
    import ChangeProgressStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails
      .builder()
      .optionallyWith(
        changeId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.changeId)
      .optionallyWith(
        startTime.map(value => UpdateTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        pendingProperties.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.pendingProperties)
      .optionallyWith(
        completedProperties.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.completedProperties)
      .optionallyWith(
        totalNumberOfStages.map(value =>
          TotalNumberOfStages.unwrap(value): Integer
        )
      )(_.totalNumberOfStages)
      .optionallyWith(
        changeProgressStages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changeProgressStages)
      .optionallyWith(configChangeStatus.map(value => value.unwrap))(
        _.configChangeStatus
      )
      .optionallyWith(
        lastUpdatedTime.map(value => UpdateTimestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(initiatedBy.map(value => value.unwrap))(_.initiatedBy)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ChangeProgressStatusDetails.ReadOnly =
    zio.aws.elasticsearch.model.ChangeProgressStatusDetails
      .wrap(buildAwsValue())
}
object ChangeProgressStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ChangeProgressStatusDetails =
      zio.aws.elasticsearch.model.ChangeProgressStatusDetails(
        changeId.map(value => value),
        startTime.map(value => value),
        status.map(value => value),
        pendingProperties.map(value => value),
        completedProperties.map(value => value),
        totalNumberOfStages.map(value => value),
        changeProgressStages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configChangeStatus.map(value => value),
        lastUpdatedTime.map(value => value),
        initiatedBy.map(value => value)
      )
    def changeId: Optional[GUID]
    def startTime: Optional[UpdateTimestamp]
    def status: Optional[zio.aws.elasticsearch.model.OverallChangeStatus]
    def pendingProperties: Optional[List[String]]
    def completedProperties: Optional[List[String]]
    def totalNumberOfStages: Optional[TotalNumberOfStages]
    def changeProgressStages: Optional[
      List[zio.aws.elasticsearch.model.ChangeProgressStage.ReadOnly]
    ]
    def configChangeStatus
        : Optional[zio.aws.elasticsearch.model.ConfigChangeStatus]
    def lastUpdatedTime: Optional[UpdateTimestamp]
    def initiatedBy: Optional[zio.aws.elasticsearch.model.InitiatedBy]
    def getChangeId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("changeId", changeId)
    def getStartTime: ZIO[Any, AwsError, UpdateTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.OverallChangeStatus] =
      AwsError.unwrapOptionField("status", status)
    def getPendingProperties: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("pendingProperties", pendingProperties)
    def getCompletedProperties: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("completedProperties", completedProperties)
    def getTotalNumberOfStages: ZIO[Any, AwsError, TotalNumberOfStages] =
      AwsError.unwrapOptionField("totalNumberOfStages", totalNumberOfStages)
    def getChangeProgressStages: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.ChangeProgressStage.ReadOnly
    ]] =
      AwsError.unwrapOptionField("changeProgressStages", changeProgressStages)
    def getConfigChangeStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.ConfigChangeStatus] =
      AwsError.unwrapOptionField("configChangeStatus", configChangeStatus)
    def getLastUpdatedTime: ZIO[Any, AwsError, UpdateTimestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getInitiatedBy
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.InitiatedBy] =
      AwsError.unwrapOptionField("initiatedBy", initiatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails
  ) extends zio.aws.elasticsearch.model.ChangeProgressStatusDetails.ReadOnly {
    override val changeId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.changeId())
      .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val startTime: Optional[UpdateTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.UpdateTimestamp(value)
      )
    override val status
        : Optional[zio.aws.elasticsearch.model.OverallChangeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.elasticsearch.model.OverallChangeStatus.wrap(value)
        )
    override val pendingProperties: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingProperties())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val completedProperties: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completedProperties())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val totalNumberOfStages: Optional[TotalNumberOfStages] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalNumberOfStages())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.TotalNumberOfStages(value)
        )
    override val changeProgressStages: Optional[
      List[zio.aws.elasticsearch.model.ChangeProgressStage.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.changeProgressStages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.ChangeProgressStage.wrap(item)
        }.toList
      )
    override val configChangeStatus
        : Optional[zio.aws.elasticsearch.model.ConfigChangeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configChangeStatus())
        .map(value =>
          zio.aws.elasticsearch.model.ConfigChangeStatus.wrap(value)
        )
    override val lastUpdatedTime: Optional[UpdateTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.UpdateTimestamp(value)
        )
    override val initiatedBy
        : Optional[zio.aws.elasticsearch.model.InitiatedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiatedBy())
        .map(value => zio.aws.elasticsearch.model.InitiatedBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails
  ): zio.aws.elasticsearch.model.ChangeProgressStatusDetails.ReadOnly =
    new Wrapper(impl)
}
