package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateElasticsearchDomainResponse(
    domainStatus: Optional[
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse = {
    import CreateElasticsearchDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse
      .builder()
      .optionallyWith(domainStatus.map(value => value.buildAwsValue()))(
        _.domainStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse.ReadOnly =
    zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse
      .wrap(buildAwsValue())
}
object CreateElasticsearchDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse =
      zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse(
        domainStatus.map(value => value.asEditable)
      )
    def domainStatus: Optional[
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly
    ]
    def getDomainStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly
    ] = AwsError.unwrapOptionField("domainStatus", domainStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse
  ) extends zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse.ReadOnly {
    override val domainStatus: Optional[
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainStatus())
      .map(value =>
        zio.aws.elasticsearch.model.ElasticsearchDomainStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse
  ): zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse.ReadOnly =
    new Wrapper(impl)
}
