package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDomainChangeProgressResponse(
    changeProgressStatus: Optional[
      zio.aws.elasticsearch.model.ChangeProgressStatusDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressResponse = {
    import DescribeDomainChangeProgressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressResponse
      .builder()
      .optionallyWith(changeProgressStatus.map(value => value.buildAwsValue()))(
        _.changeProgressStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeDomainChangeProgressResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeDomainChangeProgressResponse
      .wrap(buildAwsValue())
}
object DescribeDomainChangeProgressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeDomainChangeProgressResponse =
      zio.aws.elasticsearch.model.DescribeDomainChangeProgressResponse(
        changeProgressStatus.map(value => value.asEditable)
      )
    def changeProgressStatus: Optional[
      zio.aws.elasticsearch.model.ChangeProgressStatusDetails.ReadOnly
    ]
    def getChangeProgressStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ChangeProgressStatusDetails.ReadOnly
    ] = AwsError.unwrapOptionField("changeProgressStatus", changeProgressStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressResponse
  ) extends zio.aws.elasticsearch.model.DescribeDomainChangeProgressResponse.ReadOnly {
    override val changeProgressStatus: Optional[
      zio.aws.elasticsearch.model.ChangeProgressStatusDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.changeProgressStatus())
      .map(value =>
        zio.aws.elasticsearch.model.ChangeProgressStatusDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressResponse
  ): zio.aws.elasticsearch.model.DescribeDomainChangeProgressResponse.ReadOnly =
    new Wrapper(impl)
}
