package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeElasticsearchDomainConfigResponse(
    domainConfig: zio.aws.elasticsearch.model.ElasticsearchDomainConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse = {
    import DescribeElasticsearchDomainConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse
      .builder()
      .domainConfig(domainConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse
      .wrap(buildAwsValue())
}
object DescribeElasticsearchDomainConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse =
      zio.aws.elasticsearch.model
        .DescribeElasticsearchDomainConfigResponse(domainConfig.asEditable)
    def domainConfig
        : zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly
    def getDomainConfig: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly
    ] = ZIO.succeed(domainConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse
  ) extends zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse.ReadOnly {
    override val domainConfig
        : zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly =
      zio.aws.elasticsearch.model.ElasticsearchDomainConfig
        .wrap(impl.domainConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse
  ): zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse.ReadOnly =
    new Wrapper(impl)
}
