package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DomainEndpointOptionsStatus(
    options: zio.aws.elasticsearch.model.DomainEndpointOptions,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptionsStatus = {
    import DomainEndpointOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.DomainEndpointOptionsStatus
      .wrap(buildAwsValue())
}
object DomainEndpointOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DomainEndpointOptionsStatus =
      zio.aws.elasticsearch.model
        .DomainEndpointOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptionsStatus
  ) extends zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.ReadOnly {
    override val options
        : zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly =
      zio.aws.elasticsearch.model.DomainEndpointOptions.wrap(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptionsStatus
  ): zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
