package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait DomainPackageStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus
}
object DomainPackageStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus
  ): zio.aws.elasticsearch.model.DomainPackageStatus = value match {
    case software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.ASSOCIATING =>
      val r = ASSOCIATING
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.ASSOCIATION_FAILED =>
      val r = ASSOCIATION_FAILED
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.DISSOCIATING =>
      val r = DISSOCIATING
      r
    case software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.DISSOCIATION_FAILED =>
      val r = DISSOCIATION_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.DomainPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSOCIATING
      extends zio.aws.elasticsearch.model.DomainPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.ASSOCIATING
  }
  case object ASSOCIATION_FAILED
      extends zio.aws.elasticsearch.model.DomainPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.ASSOCIATION_FAILED
  }
  case object ACTIVE extends zio.aws.elasticsearch.model.DomainPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.ACTIVE
  }
  case object DISSOCIATING
      extends zio.aws.elasticsearch.model.DomainPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.DISSOCIATING
  }
  case object DISSOCIATION_FAILED
      extends zio.aws.elasticsearch.model.DomainPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.DomainPackageStatus.DISSOCIATION_FAILED
  }
}
