package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{Message, DeploymentType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DryRunResults(
    deploymentType: Optional[DeploymentType] = Optional.Absent,
    message: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DryRunResults = {
    import DryRunResults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DryRunResults
      .builder()
      .optionallyWith(
        deploymentType.map(value =>
          DeploymentType.unwrap(value): java.lang.String
        )
      )(_.deploymentType)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DryRunResults.ReadOnly =
    zio.aws.elasticsearch.model.DryRunResults.wrap(buildAwsValue())
}
object DryRunResults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DryRunResults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DryRunResults =
      zio.aws.elasticsearch.model.DryRunResults(
        deploymentType.map(value => value),
        message.map(value => value)
      )
    def deploymentType: Optional[DeploymentType]
    def message: Optional[Message]
    def getDeploymentType: ZIO[Any, AwsError, DeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DryRunResults
  ) extends zio.aws.elasticsearch.model.DryRunResults.ReadOnly {
    override val deploymentType: Optional[DeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.DeploymentType(value)
        )
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.elasticsearch.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DryRunResults
  ): zio.aws.elasticsearch.model.DryRunResults.ReadOnly = new Wrapper(impl)
}
