package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.IntegerClass
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EBSOptions(
    ebsEnabled: Optional[Boolean] = Optional.Absent,
    volumeType: Optional[zio.aws.elasticsearch.model.VolumeType] =
      Optional.Absent,
    volumeSize: Optional[IntegerClass] = Optional.Absent,
    iops: Optional[IntegerClass] = Optional.Absent,
    throughput: Optional[IntegerClass] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.EBSOptions = {
    import EBSOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.EBSOptions
      .builder()
      .optionallyWith(ebsEnabled.map(value => value: java.lang.Boolean))(
        _.ebsEnabled
      )
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(
        volumeSize.map(value => IntegerClass.unwrap(value): Integer)
      )(_.volumeSize)
      .optionallyWith(iops.map(value => IntegerClass.unwrap(value): Integer))(
        _.iops
      )
      .optionallyWith(
        throughput.map(value => IntegerClass.unwrap(value): Integer)
      )(_.throughput)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.EBSOptions.ReadOnly =
    zio.aws.elasticsearch.model.EBSOptions.wrap(buildAwsValue())
}
object EBSOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.EBSOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.EBSOptions =
      zio.aws.elasticsearch.model.EBSOptions(
        ebsEnabled.map(value => value),
        volumeType.map(value => value),
        volumeSize.map(value => value),
        iops.map(value => value),
        throughput.map(value => value)
      )
    def ebsEnabled: Optional[Boolean]
    def volumeType: Optional[zio.aws.elasticsearch.model.VolumeType]
    def volumeSize: Optional[IntegerClass]
    def iops: Optional[IntegerClass]
    def throughput: Optional[IntegerClass]
    def getEbsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsEnabled", ebsEnabled)
    def getVolumeType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getVolumeSize: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getIops: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("iops", iops)
    def getThroughput: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.EBSOptions
  ) extends zio.aws.elasticsearch.model.EBSOptions.ReadOnly {
    override val ebsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsEnabled())
      .map(value => value: Boolean)
    override val volumeType: Optional[zio.aws.elasticsearch.model.VolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeType())
        .map(value => zio.aws.elasticsearch.model.VolumeType.wrap(value))
    override val volumeSize: Optional[IntegerClass] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSize())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
    override val iops: Optional[IntegerClass] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
    override val throughput: Optional[IntegerClass] = zio.aws.core.internal
      .optionalFromNullable(impl.throughput())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.EBSOptions
  ): zio.aws.elasticsearch.model.EBSOptions.ReadOnly = new Wrapper(impl)
}
