package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LogPublishingOptionsStatus(
    options: Optional[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption
    ]] = Optional.Absent,
    status: Optional[zio.aws.elasticsearch.model.OptionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsStatus = {
    import LogPublishingOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsStatus
      .builder()
      .optionallyWith(
        options.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.optionsWithStrings)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.LogPublishingOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.LogPublishingOptionsStatus.wrap(buildAwsValue())
}
object LogPublishingOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.LogPublishingOptionsStatus =
      zio.aws.elasticsearch.model.LogPublishingOptionsStatus(
        options.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        status.map(value => value.asEditable)
      )
    def options: Optional[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]]
    def status: Optional[zio.aws.elasticsearch.model.OptionStatus.ReadOnly]
    def getOptions: ZIO[Any, AwsError, Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] = AwsError.unwrapOptionField("options", options)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsStatus
  ) extends zio.aws.elasticsearch.model.LogPublishingOptionsStatus.ReadOnly {
    override val options: Optional[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elasticsearch.model.LogType.wrap(
              key
            ) -> zio.aws.elasticsearch.model.LogPublishingOption.wrap(value)
          })
          .toMap
      )
    override val status
        : Optional[zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.elasticsearch.model.OptionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsStatus
  ): zio.aws.elasticsearch.model.LogPublishingOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
