package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait PackageStatus {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.PackageStatus
}
object PackageStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.PackageStatus
  ): zio.aws.elasticsearch.model.PackageStatus = value match {
    case software.amazon.awssdk.services.elasticsearch.model.PackageStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.PackageStatus.COPYING =>
      val r = COPYING
      r
    case software.amazon.awssdk.services.elasticsearch.model.PackageStatus.COPY_FAILED =>
      val r = COPY_FAILED
      r
    case software.amazon.awssdk.services.elasticsearch.model.PackageStatus.VALIDATING =>
      val r = VALIDATING
      r
    case software.amazon.awssdk.services.elasticsearch.model.PackageStatus.VALIDATION_FAILED =>
      val r = VALIDATION_FAILED
      r
    case software.amazon.awssdk.services.elasticsearch.model.PackageStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.elasticsearch.model.PackageStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.elasticsearch.model.PackageStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.elasticsearch.model.PackageStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.PackageStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COPYING extends zio.aws.elasticsearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.PackageStatus.COPYING
  }
  case object COPY_FAILED extends zio.aws.elasticsearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.PackageStatus.COPY_FAILED
  }
  case object VALIDATING extends zio.aws.elasticsearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.PackageStatus.VALIDATING
  }
  case object VALIDATION_FAILED
      extends zio.aws.elasticsearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.PackageStatus.VALIDATION_FAILED
  }
  case object AVAILABLE extends zio.aws.elasticsearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.PackageStatus.AVAILABLE
  }
  case object DELETING extends zio.aws.elasticsearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.PackageStatus.DELETING
  }
  case object DELETED extends zio.aws.elasticsearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.PackageStatus.DELETED
  }
  case object DELETE_FAILED extends zio.aws.elasticsearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageStatus =
      software.amazon.awssdk.services.elasticsearch.model.PackageStatus.DELETE_FAILED
  }
}
