package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait PrincipalType {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.PrincipalType
}
object PrincipalType {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.PrincipalType
  ): zio.aws.elasticsearch.model.PrincipalType = value match {
    case software.amazon.awssdk.services.elasticsearch.model.PrincipalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.PrincipalType.AWS_ACCOUNT =>
      val r = AWS_ACCOUNT
      r
    case software.amazon.awssdk.services.elasticsearch.model.PrincipalType.AWS_SERVICE =>
      val r = AWS_SERVICE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PrincipalType =
      software.amazon.awssdk.services.elasticsearch.model.PrincipalType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_ACCOUNT extends zio.aws.elasticsearch.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PrincipalType =
      software.amazon.awssdk.services.elasticsearch.model.PrincipalType.AWS_ACCOUNT
  }
  case object AWS_SERVICE extends zio.aws.elasticsearch.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PrincipalType =
      software.amazon.awssdk.services.elasticsearch.model.PrincipalType.AWS_SERVICE
  }
}
