package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait PropertyValueType {
  def unwrap
      : software.amazon.awssdk.services.elasticsearch.model.PropertyValueType
}
object PropertyValueType {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.PropertyValueType
  ): zio.aws.elasticsearch.model.PropertyValueType = value match {
    case software.amazon.awssdk.services.elasticsearch.model.PropertyValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.PropertyValueType.PLAIN_TEXT =>
      val r = PLAIN_TEXT
      r
    case software.amazon.awssdk.services.elasticsearch.model.PropertyValueType.STRINGIFIED_JSON =>
      val r = STRINGIFIED_JSON
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.PropertyValueType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PropertyValueType =
      software.amazon.awssdk.services.elasticsearch.model.PropertyValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object PLAIN_TEXT extends zio.aws.elasticsearch.model.PropertyValueType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PropertyValueType =
      software.amazon.awssdk.services.elasticsearch.model.PropertyValueType.PLAIN_TEXT
  }
  case object STRINGIFIED_JSON
      extends zio.aws.elasticsearch.model.PropertyValueType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PropertyValueType =
      software.amazon.awssdk.services.elasticsearch.model.PropertyValueType.STRINGIFIED_JSON
  }
}
