package zio.aws.elasticsearch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{
  ScheduledAutoTuneDescription,
  AutoTuneDate
}
import scala.jdk.CollectionConverters.*
final case class ScheduledAutoTuneDetails(
    date: Optional[AutoTuneDate] = Optional.Absent,
    actionType: Optional[
      zio.aws.elasticsearch.model.ScheduledAutoTuneActionType
    ] = Optional.Absent,
    action: Optional[ScheduledAutoTuneDescription] = Optional.Absent,
    severity: Optional[
      zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails = {
    import ScheduledAutoTuneDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails
      .builder()
      .optionallyWith(date.map(value => AutoTuneDate.unwrap(value): Instant))(
        _.date
      )
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(
        action.map(value =>
          ScheduledAutoTuneDescription.unwrap(value): java.lang.String
        )
      )(_.action)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly =
    zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.wrap(buildAwsValue())
}
object ScheduledAutoTuneDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ScheduledAutoTuneDetails =
      zio.aws.elasticsearch.model.ScheduledAutoTuneDetails(
        date.map(value => value),
        actionType.map(value => value),
        action.map(value => value),
        severity.map(value => value)
      )
    def date: Optional[AutoTuneDate]
    def actionType
        : Optional[zio.aws.elasticsearch.model.ScheduledAutoTuneActionType]
    def action: Optional[ScheduledAutoTuneDescription]
    def severity
        : Optional[zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType]
    def getDate: ZIO[Any, AwsError, AutoTuneDate] =
      AwsError.unwrapOptionField("date", date)
    def getActionType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ScheduledAutoTuneActionType
    ] = AwsError.unwrapOptionField("actionType", actionType)
    def getAction: ZIO[Any, AwsError, ScheduledAutoTuneDescription] =
      AwsError.unwrapOptionField("action", action)
    def getSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType
    ] = AwsError.unwrapOptionField("severity", severity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails
  ) extends zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly {
    override val date: Optional[AutoTuneDate] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.elasticsearch.model.primitives.AutoTuneDate(value))
    override val actionType
        : Optional[zio.aws.elasticsearch.model.ScheduledAutoTuneActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value =>
          zio.aws.elasticsearch.model.ScheduledAutoTuneActionType.wrap(value)
        )
    override val action: Optional[ScheduledAutoTuneDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .ScheduledAutoTuneDescription(value)
        )
    override val severity
        : Optional[zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value =>
          zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails
  ): zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly =
    new Wrapper(impl)
}
