package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait TLSSecurityPolicy {
  def unwrap
      : software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy
}
object TLSSecurityPolicy {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy
  ): zio.aws.elasticsearch.model.TLSSecurityPolicy = value match {
    case software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_0_2019_07 =>
      val r = `Policy-Min-TLS-1-0-2019-07`
      r
    case software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_2_2019_07 =>
      val r = `Policy-Min-TLS-1-2-2019-07`
      r
    case software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_2_PFS_2023_10 =>
      val r = `Policy-Min-TLS-1-2-PFS-2023-10`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.TLSSecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy =
      software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object `Policy-Min-TLS-1-0-2019-07`
      extends zio.aws.elasticsearch.model.TLSSecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy =
      software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_0_2019_07
  }
  case object `Policy-Min-TLS-1-2-2019-07`
      extends zio.aws.elasticsearch.model.TLSSecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy =
      software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_2_2019_07
  }
  case object `Policy-Min-TLS-1-2-PFS-2023-10`
      extends zio.aws.elasticsearch.model.TLSSecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy =
      software.amazon.awssdk.services.elasticsearch.model.TLSSecurityPolicy.POLICY_MIN_TLS_1_2_PFS_2023_10
  }
}
