package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait UpgradeStatus {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus
}
object UpgradeStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus
  ): zio.aws.elasticsearch.model.UpgradeStatus = value match {
    case software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.SUCCEEDED_WITH_ISSUES =>
      val r = SUCCEEDED_WITH_ISSUES
      r
    case software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus =
      software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.elasticsearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus =
      software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.elasticsearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus =
      software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.SUCCEEDED
  }
  case object SUCCEEDED_WITH_ISSUES
      extends zio.aws.elasticsearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus =
      software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.SUCCEEDED_WITH_ISSUES
  }
  case object FAILED extends zio.aws.elasticsearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus =
      software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus.FAILED
  }
}
