package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VPCDerivedInfoStatus(
    options: zio.aws.elasticsearch.model.VPCDerivedInfo,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfoStatus = {
    import VPCDerivedInfoStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfoStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.VPCDerivedInfoStatus.ReadOnly =
    zio.aws.elasticsearch.model.VPCDerivedInfoStatus.wrap(buildAwsValue())
}
object VPCDerivedInfoStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfoStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.VPCDerivedInfoStatus =
      zio.aws.elasticsearch.model
        .VPCDerivedInfoStatus(options.asEditable, status.asEditable)
    def options: zio.aws.elasticsearch.model.VPCDerivedInfo.ReadOnly
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.VPCDerivedInfo.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfoStatus
  ) extends zio.aws.elasticsearch.model.VPCDerivedInfoStatus.ReadOnly {
    override val options: zio.aws.elasticsearch.model.VPCDerivedInfo.ReadOnly =
      zio.aws.elasticsearch.model.VPCDerivedInfo.wrap(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfoStatus
  ): zio.aws.elasticsearch.model.VPCDerivedInfoStatus.ReadOnly = new Wrapper(
    impl
  )
}
