package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait VpcEndpointErrorCode {
  def unwrap
      : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode
}
object VpcEndpointErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode
  ): zio.aws.elasticsearch.model.VpcEndpointErrorCode = value match {
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode.ENDPOINT_NOT_FOUND =>
      val r = ENDPOINT_NOT_FOUND
      r
    case software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode.SERVER_ERROR =>
      val r = SERVER_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.VpcEndpointErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ENDPOINT_NOT_FOUND
      extends zio.aws.elasticsearch.model.VpcEndpointErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode.ENDPOINT_NOT_FOUND
  }
  case object SERVER_ERROR
      extends zio.aws.elasticsearch.model.VpcEndpointErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode =
      software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode.SERVER_ERROR
  }
}
