package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait AdjustmentType {
  def unwrap: software.amazon.awssdk.services.emr.model.AdjustmentType
}
object AdjustmentType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.AdjustmentType
  ): zio.aws.emr.model.AdjustmentType = value match {
    case software.amazon.awssdk.services.emr.model.AdjustmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.AdjustmentType.CHANGE_IN_CAPACITY =>
      val r = CHANGE_IN_CAPACITY
      r
    case software.amazon.awssdk.services.emr.model.AdjustmentType.PERCENT_CHANGE_IN_CAPACITY =>
      val r = PERCENT_CHANGE_IN_CAPACITY
      r
    case software.amazon.awssdk.services.emr.model.AdjustmentType.EXACT_CAPACITY =>
      val r = EXACT_CAPACITY
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.AdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AdjustmentType =
      software.amazon.awssdk.services.emr.model.AdjustmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object CHANGE_IN_CAPACITY extends zio.aws.emr.model.AdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AdjustmentType =
      software.amazon.awssdk.services.emr.model.AdjustmentType.CHANGE_IN_CAPACITY
  }
  case object PERCENT_CHANGE_IN_CAPACITY
      extends zio.aws.emr.model.AdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AdjustmentType =
      software.amazon.awssdk.services.emr.model.AdjustmentType.PERCENT_CHANGE_IN_CAPACITY
  }
  case object EXACT_CAPACITY extends zio.aws.emr.model.AdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AdjustmentType =
      software.amazon.awssdk.services.emr.model.AdjustmentType.EXACT_CAPACITY
  }
}
