package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExecutionEngineConfig(
    id: XmlStringMaxLen256,
    `type`: Option[zio.aws.emr.model.ExecutionEngineType] = None,
    masterInstanceSecurityGroupId: Option[XmlStringMaxLen256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ExecutionEngineConfig = {
    import ExecutionEngineConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ExecutionEngineConfig
      .builder()
      .id(XmlStringMaxLen256.unwrap(id): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        masterInstanceSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.masterInstanceSecurityGroupId)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ExecutionEngineConfig.ReadOnly =
    zio.aws.emr.model.ExecutionEngineConfig.wrap(buildAwsValue())
}
object ExecutionEngineConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ExecutionEngineConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ExecutionEngineConfig =
      zio.aws.emr.model.ExecutionEngineConfig(
        id,
        `type`.map(value => value),
        masterInstanceSecurityGroupId.map(value => value)
      )
    def id: XmlStringMaxLen256
    def `type`: Option[zio.aws.emr.model.ExecutionEngineType]
    def masterInstanceSecurityGroupId: Option[XmlStringMaxLen256]
    def getId: ZIO[Any, Nothing, XmlStringMaxLen256] = ZIO.succeed(id)
    def getType: ZIO[Any, AwsError, zio.aws.emr.model.ExecutionEngineType] =
      AwsError.unwrapOptionField("type", `type`)
    def getMasterInstanceSecurityGroupId
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "masterInstanceSecurityGroupId",
      masterInstanceSecurityGroupId
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ExecutionEngineConfig
  ) extends zio.aws.emr.model.ExecutionEngineConfig.ReadOnly {
    override val id: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.id())
    override val `type`: Option[zio.aws.emr.model.ExecutionEngineType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.emr.model.ExecutionEngineType.wrap(value))
    override val masterInstanceSecurityGroupId: Option[XmlStringMaxLen256] =
      scala
        .Option(impl.masterInstanceSecurityGroupId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ExecutionEngineConfig
  ): zio.aws.emr.model.ExecutionEngineConfig.ReadOnly = new Wrapper(impl)
}
