package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HadoopStepConfig(
    jar: Option[String] = None,
    properties: Option[Map[String, String]] = None,
    mainClass: Option[String] = None,
    args: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.HadoopStepConfig = {
    import HadoopStepConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.HadoopStepConfig
      .builder()
      .optionallyWith(jar.map(value => value: java.lang.String))(_.jar)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(mainClass.map(value => value: java.lang.String))(
        _.mainClass
      )
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.HadoopStepConfig.ReadOnly =
    zio.aws.emr.model.HadoopStepConfig.wrap(buildAwsValue())
}
object HadoopStepConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.HadoopStepConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.HadoopStepConfig =
      zio.aws.emr.model.HadoopStepConfig(
        jar.map(value => value),
        properties.map(value => value),
        mainClass.map(value => value),
        args.map(value => value)
      )
    def jar: Option[String]
    def properties: Option[Map[String, String]]
    def mainClass: Option[String]
    def args: Option[List[String]]
    def getJar: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jar", jar)
    def getProperties: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("properties", properties)
    def getMainClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mainClass", mainClass)
    def getArgs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("args", args)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.HadoopStepConfig
  ) extends zio.aws.emr.model.HadoopStepConfig.ReadOnly {
    override val jar: Option[String] =
      scala.Option(impl.jar()).map(value => value: String)
    override val properties: Option[Map[String, String]] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val mainClass: Option[String] =
      scala.Option(impl.mainClass()).map(value => value: String)
    override val args: Option[List[String]] = scala
      .Option(impl.args())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.HadoopStepConfig
  ): zio.aws.emr.model.HadoopStepConfig.ReadOnly = new Wrapper(impl)
}
