package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInstanceGroupsResponse(
    instanceGroups: Option[Iterable[zio.aws.emr.model.InstanceGroup]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse = {
    import ListInstanceGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse
      .builder()
      .optionallyWith(
        instanceGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceGroups)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListInstanceGroupsResponse.ReadOnly =
    zio.aws.emr.model.ListInstanceGroupsResponse.wrap(buildAwsValue())
}
object ListInstanceGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListInstanceGroupsResponse =
      zio.aws.emr.model.ListInstanceGroupsResponse(
        instanceGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def instanceGroups: Option[List[zio.aws.emr.model.InstanceGroup.ReadOnly]]
    def marker: Option[Marker]
    def getInstanceGroups
        : ZIO[Any, AwsError, List[zio.aws.emr.model.InstanceGroup.ReadOnly]] =
      AwsError.unwrapOptionField("instanceGroups", instanceGroups)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse
  ) extends zio.aws.emr.model.ListInstanceGroupsResponse.ReadOnly {
    override val instanceGroups
        : Option[List[zio.aws.emr.model.InstanceGroup.ReadOnly]] = scala
      .Option(impl.instanceGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.InstanceGroup.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse
  ): zio.aws.emr.model.ListInstanceGroupsResponse.ReadOnly = new Wrapper(impl)
}
