package zio.aws.emr.model
import zio.aws.emr.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddTagsRequest(
    resourceId: ResourceId,
    tags: Iterable[zio.aws.emr.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AddTagsRequest = {
    import AddTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AddTagsRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AddTagsRequest.ReadOnly =
    zio.aws.emr.model.AddTagsRequest.wrap(buildAwsValue())
}
object AddTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AddTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AddTagsRequest =
      zio.aws.emr.model.AddTagsRequest(
        resourceId,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceId: ResourceId
    def tags: List[zio.aws.emr.model.Tag.ReadOnly]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTags: ZIO[Any, Nothing, List[zio.aws.emr.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AddTagsRequest
  ) extends zio.aws.emr.model.AddTagsRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.emr.model.primitives.ResourceId(impl.resourceId())
    override val tags: List[zio.aws.emr.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.emr.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AddTagsRequest
  ): zio.aws.emr.model.AddTagsRequest.ReadOnly = new Wrapper(impl)
}
