package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait ComputeLimitsUnitType {
  def unwrap: software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType
}
object ComputeLimitsUnitType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType
  ): zio.aws.emr.model.ComputeLimitsUnitType = value match {
    case software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType.INSTANCE_FLEET_UNITS =>
      val r = InstanceFleetUnits
      r
    case software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType.INSTANCES =>
      val r = Instances
      r
    case software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType.VCPU =>
      val r = VCPU
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.ComputeLimitsUnitType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType =
      software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType.UNKNOWN_TO_SDK_VERSION
  }
  case object InstanceFleetUnits
      extends zio.aws.emr.model.ComputeLimitsUnitType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType =
      software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType.INSTANCE_FLEET_UNITS
  }
  case object Instances extends zio.aws.emr.model.ComputeLimitsUnitType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType =
      software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType.INSTANCES
  }
  case object VCPU extends zio.aws.emr.model.ComputeLimitsUnitType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType =
      software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType.VCPU
  }
}
