package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateSecurityConfigurationRequest(
    name: XmlString,
    securityConfiguration: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationRequest = {
    import CreateSecurityConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationRequest
      .builder()
      .name(XmlString.unwrap(name): java.lang.String)
      .securityConfiguration(securityConfiguration: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.CreateSecurityConfigurationRequest.ReadOnly =
    zio.aws.emr.model.CreateSecurityConfigurationRequest.wrap(buildAwsValue())
}
object CreateSecurityConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.CreateSecurityConfigurationRequest =
      zio.aws.emr.model
        .CreateSecurityConfigurationRequest(name, securityConfiguration)
    def name: XmlString
    def securityConfiguration: String
    def getName: ZIO[Any, Nothing, XmlString] = ZIO.succeed(name)
    def getSecurityConfiguration: ZIO[Any, Nothing, String] =
      ZIO.succeed(securityConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationRequest
  ) extends zio.aws.emr.model.CreateSecurityConfigurationRequest.ReadOnly {
    override val name: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.name())
    override val securityConfiguration: String =
      impl.securityConfiguration(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationRequest
  ): zio.aws.emr.model.CreateSecurityConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
