package zio.aws.emr.model
import zio.aws.emr.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeClusterRequest(clusterId: ClusterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeClusterRequest = {
    import DescribeClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeClusterRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeClusterRequest.ReadOnly =
    zio.aws.emr.model.DescribeClusterRequest.wrap(buildAwsValue())
}
object DescribeClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeClusterRequest =
      zio.aws.emr.model.DescribeClusterRequest(clusterId)
    def clusterId: ClusterId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeClusterRequest
  ) extends zio.aws.emr.model.DescribeClusterRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeClusterRequest
  ): zio.aws.emr.model.DescribeClusterRequest.ReadOnly = new Wrapper(impl)
}
