package zio.aws.emr.model
import java.lang.Integer
import zio.aws.emr.model.primitives.{WholeNumber, InstanceFleetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceFleetModifyConfig(
    instanceFleetId: InstanceFleetId,
    targetOnDemandCapacity: Option[WholeNumber] = None,
    targetSpotCapacity: Option[WholeNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig = {
    import InstanceFleetModifyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
      .builder()
      .instanceFleetId(
        InstanceFleetId.unwrap(instanceFleetId): java.lang.String
      )
      .optionallyWith(
        targetOnDemandCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetOnDemandCapacity)
      .optionallyWith(
        targetSpotCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetSpotCapacity)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly =
    zio.aws.emr.model.InstanceFleetModifyConfig.wrap(buildAwsValue())
}
object InstanceFleetModifyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetModifyConfig =
      zio.aws.emr.model.InstanceFleetModifyConfig(
        instanceFleetId,
        targetOnDemandCapacity.map(value => value),
        targetSpotCapacity.map(value => value)
      )
    def instanceFleetId: InstanceFleetId
    def targetOnDemandCapacity: Option[WholeNumber]
    def targetSpotCapacity: Option[WholeNumber]
    def getInstanceFleetId: ZIO[Any, Nothing, InstanceFleetId] =
      ZIO.succeed(instanceFleetId)
    def getTargetOnDemandCapacity: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("targetOnDemandCapacity", targetOnDemandCapacity)
    def getTargetSpotCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("targetSpotCapacity", targetSpotCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
  ) extends zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly {
    override val instanceFleetId: InstanceFleetId =
      zio.aws.emr.model.primitives.InstanceFleetId(impl.instanceFleetId())
    override val targetOnDemandCapacity: Option[WholeNumber] = scala
      .Option(impl.targetOnDemandCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val targetSpotCapacity: Option[WholeNumber] = scala
      .Option(impl.targetSpotCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
  ): zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly = new Wrapper(impl)
}
