package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait InstanceFleetStateChangeReasonCode {
  def unwrap: software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode
}
object InstanceFleetStateChangeReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode
  ): zio.aws.emr.model.InstanceFleetStateChangeReasonCode = value match {
    case software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.VALIDATION_ERROR =>
      val r = VALIDATION_ERROR
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.INSTANCE_FAILURE =>
      val r = INSTANCE_FAILURE
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.CLUSTER_TERMINATED =>
      val r = CLUSTER_TERMINATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.InstanceFleetStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.emr.model.InstanceFleetStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.INTERNAL_ERROR
  }
  case object VALIDATION_ERROR
      extends zio.aws.emr.model.InstanceFleetStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.VALIDATION_ERROR
  }
  case object INSTANCE_FAILURE
      extends zio.aws.emr.model.InstanceFleetStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.INSTANCE_FAILURE
  }
  case object CLUSTER_TERMINATED
      extends zio.aws.emr.model.InstanceFleetStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReasonCode.CLUSTER_TERMINATED
  }
}
