package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait InstanceGroupType {
  def unwrap: software.amazon.awssdk.services.emr.model.InstanceGroupType
}
object InstanceGroupType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.InstanceGroupType
  ): zio.aws.emr.model.InstanceGroupType = value match {
    case software.amazon.awssdk.services.emr.model.InstanceGroupType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupType.MASTER =>
      val r = MASTER
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupType.CORE =>
      val r = CORE
      r
    case software.amazon.awssdk.services.emr.model.InstanceGroupType.TASK =>
      val r = TASK
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.InstanceGroupType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupType =
      software.amazon.awssdk.services.emr.model.InstanceGroupType.UNKNOWN_TO_SDK_VERSION
  }
  case object MASTER extends zio.aws.emr.model.InstanceGroupType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupType =
      software.amazon.awssdk.services.emr.model.InstanceGroupType.MASTER
  }
  case object CORE extends zio.aws.emr.model.InstanceGroupType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupType =
      software.amazon.awssdk.services.emr.model.InstanceGroupType.CORE
  }
  case object TASK extends zio.aws.emr.model.InstanceGroupType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceGroupType =
      software.amazon.awssdk.services.emr.model.InstanceGroupType.TASK
  }
}
