package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait InstanceRoleType {
  def unwrap: software.amazon.awssdk.services.emr.model.InstanceRoleType
}
object InstanceRoleType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.InstanceRoleType
  ): zio.aws.emr.model.InstanceRoleType = value match {
    case software.amazon.awssdk.services.emr.model.InstanceRoleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.InstanceRoleType.MASTER =>
      val r = MASTER
      r
    case software.amazon.awssdk.services.emr.model.InstanceRoleType.CORE =>
      val r = CORE
      r
    case software.amazon.awssdk.services.emr.model.InstanceRoleType.TASK =>
      val r = TASK
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.InstanceRoleType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceRoleType =
      software.amazon.awssdk.services.emr.model.InstanceRoleType.UNKNOWN_TO_SDK_VERSION
  }
  case object MASTER extends zio.aws.emr.model.InstanceRoleType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceRoleType =
      software.amazon.awssdk.services.emr.model.InstanceRoleType.MASTER
  }
  case object CORE extends zio.aws.emr.model.InstanceRoleType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceRoleType =
      software.amazon.awssdk.services.emr.model.InstanceRoleType.CORE
  }
  case object TASK extends zio.aws.emr.model.InstanceRoleType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceRoleType =
      software.amazon.awssdk.services.emr.model.InstanceRoleType.TASK
  }
}
