package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInstancesResponse(
    instances: Option[Iterable[zio.aws.emr.model.Instance]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListInstancesResponse = {
    import ListInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListInstancesResponse.ReadOnly =
    zio.aws.emr.model.ListInstancesResponse.wrap(buildAwsValue())
}
object ListInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListInstancesResponse =
      zio.aws.emr.model.ListInstancesResponse(
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def instances: Option[List[zio.aws.emr.model.Instance.ReadOnly]]
    def marker: Option[Marker]
    def getInstances
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Instance.ReadOnly]] =
      AwsError.unwrapOptionField("instances", instances)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListInstancesResponse
  ) extends zio.aws.emr.model.ListInstancesResponse.ReadOnly {
    override val instances: Option[List[zio.aws.emr.model.Instance.ReadOnly]] =
      scala
        .Option(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Instance.wrap(item)
          }.toList
        )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListInstancesResponse
  ): zio.aws.emr.model.ListInstancesResponse.ReadOnly = new Wrapper(impl)
}
